/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ClusterReduction
implements ClusterReductionConstants {
    public static Hashtable nameToNum;
    public static Hashtable numToName;
    public static int seenLeaves;
    public static TreeNode t1;
    public static TreeNode t2;
    public static boolean VERBOSE;
    public static Hashtable clusterTable;
    public static String xUpDownSuffix;
    public static TreeNode tree;
    public static TreeNode current_node;
    private static TreeNode tn;
    public static int leaves;
    public static int trees;
    public static String VERSION;
    private static boolean jj_initialized_once;
    public static ClusterReductionTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;

    public static int getLeafNumber(String string) {
        Integer n;
        if (nameToNum == null) {
            nameToNum = new Hashtable();
        }
        if ((n = (Integer)nameToNum.get(string)) != null) {
            return n;
        }
        n = ++seenLeaves;
        nameToNum.put(string, n);
        if (numToName == null) {
            numToName = new Hashtable();
        }
        numToName.put(n, string);
        return seenLeaves;
    }

    public static String getLeafName(int n) {
        Integer n2 = n;
        if (numToName == null) {
            numToName = new Hashtable();
        }
        String string = (String)numToName.get(n2);
        return string;
    }

    public static String extractMaximalNumericSuffix(String string) {
        int n;
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (n = string.length() - 1; n >= 0 && Character.isDigit(string.charAt(n)); --n) {
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static Integer computeNextIndex(Hashtable hashtable) {
        if (hashtable == null || hashtable.isEmpty()) {
            return null;
        }
        boolean bl = false;
        int n = -1;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = (String)k;
            if (!string.startsWith("X_UP") && !string.startsWith("X_DOWN")) continue;
            bl = true;
            String string2 = ClusterReduction.extractMaximalNumericSuffix(string);
            if (string2 == null) continue;
            try {
                int n2 = Integer.parseInt(string2);
                n = Math.max(n, n2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!bl) {
            return null;
        }
        return n == -1 ? 1 : n + 1;
    }

    public static void parseTrees() {
        ClusterReduction clusterReduction = new ClusterReduction(System.in);
        try {
            clusterReduction.Input();
        }
        catch (ParseException parseException) {
            System.out.println("Parsing error! Trees were malformed.");
            parseException.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            System.out.println("args[0] = " + stringArray[0]);
            if (stringArray[0].equals("-v") || stringArray[0].equals("--v") || stringArray[0].equals("--verbose")) {
                System.out.println("// Switching verbose mode on.");
                VERBOSE = true;
            }
        }
        ClusterReduction.parseTrees();
    }

    public static final void Input() throws ParseException {
        TreeNode treeNode;
        Object object;
        while (ClusterReduction.jj_2_1(2)) {
            current_node = tree = new TreeNode();
            leaves = 0;
            ClusterReduction.descendant_list();
            if (ClusterReduction.jj_2_2(2)) {
                String string = ClusterReduction.label();
            }
            if (ClusterReduction.jj_2_3(2)) {
                ClusterReduction.jj_consume_token(7);
                double d = ClusterReduction.branch_length();
            }
            ClusterReduction.jj_consume_token(8);
            if (++trees > 2) {
                System.out.println("Only two trees allowed in the input! Stopping.");
                System.exit(0);
            }
            if (trees == 1) {
                t1 = tree;
                continue;
            }
            if (trees != 2) continue;
            t2 = tree;
        }
        ClusterReduction.jj_consume_token(0);
        System.out.print(VERSION);
        System.out.println("// Applies the cluster reduction ONCE, preferring a common cluster");
        System.out.println("// that has size closest to (n/2) where n is the number of taxa.");
        System.out.println("// Note that it ignores clusters of size 1, 2, n-1 and n.");
        System.out.println("// ===============================================================");
        System.out.println("// Original trees: ");
        System.out.print("// ");
        t1.dumpTree();
        System.out.println(";");
        System.out.print("// ");
        t2.dumpTree();
        System.out.println(";");
        System.out.println("// ===============================================================");
        int n = seenLeaves;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        t1.createDescendantsLookUp(n);
        t2.createDescendantsLookUp(n);
        t1.putDescendantsInHashTable(hashtable);
        t2.putDescendantsInHashTable(hashtable2);
        int n2 = 0;
        TreeNode treeNode2 = null;
        TreeNode treeNode3 = null;
        Enumeration enumeration = hashtable.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            treeNode = (TreeNode)hashtable2.get(object);
            if (treeNode == null) continue;
            int n3 = treeNode.numDescendants;
            if (n3 <= 2 || n3 >= n - 1) {
                if (!VERBOSE) continue;
                System.out.println("// Rejected an uninteresting common cluster, size = " + n3);
                continue;
            }
            if (!bl) {
                if (VERBOSE) {
                    System.out.println("// Found an initial common cluster, size = " + n3);
                }
                bl = true;
                n2 = n3;
                treeNode3 = treeNode;
                treeNode2 = (TreeNode)hashtable.get(object);
                continue;
            }
            int n4 = Math.abs(n / 2 - n3);
            if (n4 < Math.abs(n / 2 - n2)) {
                if (VERBOSE) {
                    System.out.println("// Found a more balanced common cluster (size = " + n3 + ").");
                }
                n2 = n3;
                treeNode3 = treeNode;
                treeNode2 = (TreeNode)hashtable.get(object);
                continue;
            }
            if (!VERBOSE) continue;
            System.out.println("// Rejected a less balanced common cluster (size = " + n3 + ").");
        }
        if (!bl) {
            System.out.println("// No interesting common clusters found; terminating.");
            System.exit(1);
        }
        System.out.println("// Most balanced common cluster had size " + n2);
        System.out.println("// ===============================================================");
        object = ClusterReduction.computeNextIndex(nameToNum);
        if (object == null) {
            xUpDownSuffix = "";
        } else {
            xUpDownSuffix = "_" + ((Integer)object).toString();
            System.out.println("// Spotted that there are aleady taxa that begin with X_UP or X_DOWN -- adding");
            System.out.println("// the numerical suffix " + xUpDownSuffix + " to avoid conflict, so the placeholders");
            System.out.println("// will be X_UP" + xUpDownSuffix + " and X_DOWN" + xUpDownSuffix + ".");
        }
        System.out.println("// Tree pair 1: the bottom part of the trees with a taxon to mark the root of the cluster");
        System.out.print("(");
        treeNode2.dumpTree();
        System.out.println(",X_DOWN" + xUpDownSuffix + ");");
        System.out.print("(");
        treeNode3.dumpTree();
        System.out.println(",X_DOWN" + xUpDownSuffix + ");");
        System.out.println("// Tree pair 2: the bottom part of the trees WITHOUT a taxon to mark the root of the cluster:");
        treeNode2.dumpTree();
        System.out.println(";");
        treeNode3.dumpTree();
        System.out.println(";");
        System.out.println("// Tree pair 3: the top part of the trees with a placeholder taxon for the cluster.");
        treeNode2.stopHere = true;
        treeNode3.stopHere = true;
        t1.dumpTree();
        System.out.println(";");
        t2.dumpTree();
        System.out.println(";");
        System.out.println("// Tree pair 4: the top part of the trees WITHOUT a placeholder taxon for the cluster.");
        treeNode = treeNode2.incidentToRoot();
        TreeNode treeNode4 = treeNode3.incidentToRoot();
        if (treeNode == null) {
            treeNode2.deleteNode();
            treeNode = t1;
        } else {
            treeNode.parent = null;
        }
        if (treeNode4 == null) {
            treeNode3.deleteNode();
            treeNode4 = t2;
        } else {
            treeNode4.parent = null;
        }
        treeNode.dumpTree();
        System.out.println(";");
        treeNode4.dumpTree();
        System.out.println(";");
        System.out.println("// ===============================================================");
        System.out.println("// Cheat sheet:");
        System.out.println("// Let K = OPT(TP2) + OPT(TP4) where TP means 'tree pair'.");
        System.out.println("// Is [OPT(TP1) = OPT(TP2)] AND [OPT(TP3)=OPT(TP4)]? Then OPT = K-1.");
        System.out.println("// Else, OPT = K.");
        System.out.println("// ===============================================================");
        System.out.println("// Here, the OPTs are the minimum number of components in a rooted agreement forest.");
    }

    public static final void descendant_list() throws ParseException {
        int n = 0;
        ClusterReduction.jj_consume_token(9);
        ++n;
        tn = new TreeNode();
        tn.setParent(current_node);
        current_node.addChild(tn);
        current_node = tn;
        ClusterReduction.subtree();
        while (ClusterReduction.jj_2_4(2)) {
            ClusterReduction.jj_consume_token(10);
            ++n;
            tn = new TreeNode();
            tn.setParent(current_node);
            current_node.addChild(tn);
            current_node = tn;
            ClusterReduction.subtree();
        }
        ClusterReduction.jj_consume_token(11);
    }

    public static final void subtree() throws ParseException {
        if (ClusterReduction.jj_2_9(2)) {
            ClusterReduction.descendant_list();
            if (ClusterReduction.jj_2_5(2)) {
                String string = ClusterReduction.label();
            }
            if (ClusterReduction.jj_2_6(2)) {
                ClusterReduction.jj_consume_token(7);
                double d = ClusterReduction.branch_length();
            }
            current_node = current_node.getParent();
        } else {
            if (ClusterReduction.jj_2_7(2)) {
                String string = ClusterReduction.label();
                ++leaves;
                int n = ClusterReduction.getLeafNumber(string);
                current_node.setName(string);
                current_node.setNumber(n);
            }
            if (ClusterReduction.jj_2_8(2)) {
                ClusterReduction.jj_consume_token(7);
                double d = ClusterReduction.branch_length();
            }
            current_node = ClusterReduction.current_node.parent;
        }
    }

    public static final String label() throws ParseException {
        if (ClusterReduction.jj_2_10(2)) {
            String string = ClusterReduction.unquoted_label();
            return string;
        }
        if (ClusterReduction.jj_2_11(2)) {
            String string = ClusterReduction.quoted_label();
            return string;
        }
        ClusterReduction.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final String unquoted_label() throws ParseException {
        if (ClusterReduction.jj_2_12(2)) {
            Token token = ClusterReduction.jj_consume_token(23);
            String string = new String(token.toString());
            return string;
        }
        if (ClusterReduction.jj_2_13(2)) {
            Token token = ClusterReduction.jj_consume_token(22);
            return new String(token.toString());
        }
        ClusterReduction.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final String quoted_label() throws ParseException {
        Token token = ClusterReduction.jj_consume_token(24);
        String string = new String(token.toString());
        return string.substring(1, string.length() - 1);
    }

    public static final double branch_length() throws ParseException {
        Token token = ClusterReduction.jj_consume_token(22);
        return Double.parseDouble(token.toString());
    }

    private static boolean jj_2_1(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(0, n);
        }
    }

    private static boolean jj_2_2(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(1, n);
        }
    }

    private static boolean jj_2_3(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(2, n);
        }
    }

    private static boolean jj_2_4(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(3, n);
        }
    }

    private static boolean jj_2_5(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(4, n);
        }
    }

    private static boolean jj_2_6(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(5, n);
        }
    }

    private static boolean jj_2_7(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(6, n);
        }
    }

    private static boolean jj_2_8(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(7, n);
        }
    }

    private static boolean jj_2_9(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(8, n);
        }
    }

    private static boolean jj_2_10(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(9, n);
        }
    }

    private static boolean jj_2_11(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(10, n);
        }
    }

    private static boolean jj_2_12(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(11, n);
        }
    }

    private static boolean jj_2_13(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !ClusterReduction.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            ClusterReduction.jj_save(12, n);
        }
    }

    private static boolean jj_3_10() {
        return ClusterReduction.jj_3R_7();
    }

    private static boolean jj_3R_4() {
        Token token = jj_scanpos;
        if (ClusterReduction.jj_3_10()) {
            jj_scanpos = token;
            if (ClusterReduction.jj_3_11()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3_8() {
        if (ClusterReduction.jj_scan_token(7)) {
            return true;
        }
        return ClusterReduction.jj_3R_5();
    }

    private static boolean jj_3_7() {
        return ClusterReduction.jj_3R_4();
    }

    private static boolean jj_3R_9() {
        Token token = jj_scanpos;
        if (ClusterReduction.jj_3_7()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (ClusterReduction.jj_3_8()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3_6() {
        if (ClusterReduction.jj_scan_token(7)) {
            return true;
        }
        return ClusterReduction.jj_3R_5();
    }

    private static boolean jj_3_5() {
        return ClusterReduction.jj_3R_4();
    }

    private static boolean jj_3_9() {
        return ClusterReduction.jj_3R_3();
    }

    private static boolean jj_3R_6() {
        Token token = jj_scanpos;
        if (ClusterReduction.jj_3_9()) {
            jj_scanpos = token;
            if (ClusterReduction.jj_3R_9()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_5() {
        return ClusterReduction.jj_scan_token(22);
    }

    private static boolean jj_3R_8() {
        return ClusterReduction.jj_scan_token(24);
    }

    private static boolean jj_3_3() {
        if (ClusterReduction.jj_scan_token(7)) {
            return true;
        }
        return ClusterReduction.jj_3R_5();
    }

    private static boolean jj_3_2() {
        return ClusterReduction.jj_3R_4();
    }

    private static boolean jj_3_13() {
        return ClusterReduction.jj_scan_token(22);
    }

    private static boolean jj_3_4() {
        if (ClusterReduction.jj_scan_token(10)) {
            return true;
        }
        return ClusterReduction.jj_3R_6();
    }

    private static boolean jj_3_1() {
        return ClusterReduction.jj_3R_3();
    }

    private static boolean jj_3R_7() {
        Token token = jj_scanpos;
        if (ClusterReduction.jj_3_12()) {
            jj_scanpos = token;
            if (ClusterReduction.jj_3_13()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3_12() {
        return ClusterReduction.jj_scan_token(23);
    }

    private static boolean jj_3R_3() {
        Token token;
        if (ClusterReduction.jj_scan_token(9)) {
            return true;
        }
        if (ClusterReduction.jj_3R_6()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!ClusterReduction.jj_3_4());
        jj_scanpos = token;
        return ClusterReduction.jj_scan_token(11);
    }

    private static boolean jj_3_11() {
        return ClusterReduction.jj_3R_8();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    public ClusterReduction(InputStream inputStream) {
        this(inputStream, null);
    }

    public ClusterReduction(InputStream inputStream, String string) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        token_source = new ClusterReductionTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 0; ++n) {
            ClusterReduction.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            ClusterReduction.jj_2_rtns[n] = new JJCalls();
        }
    }

    public static void ReInit(InputStream inputStream) {
        ClusterReduction.ReInit(inputStream, null);
    }

    public static void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        ClusterReductionTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 0; ++n) {
            ClusterReduction.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            ClusterReduction.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ClusterReduction(Reader reader) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(reader, 1, 1);
        token_source = new ClusterReductionTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 0; ++n) {
            ClusterReduction.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            ClusterReduction.jj_2_rtns[n] = new JJCalls();
        }
    }

    public static void ReInit(Reader reader) {
        int n;
        jj_input_stream.ReInit(reader, 1, 1);
        ClusterReductionTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 0; ++n) {
            ClusterReduction.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            ClusterReduction.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ClusterReduction(ClusterReductionTokenManager clusterReductionTokenManager) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = clusterReductionTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 0; ++n) {
            ClusterReduction.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            ClusterReduction.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ClusterReductionTokenManager clusterReductionTokenManager) {
        int n;
        token_source = clusterReductionTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 0; ++n) {
            ClusterReduction.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            ClusterReduction.jj_2_rtns[n] = new JJCalls();
        }
    }

    private static Token jj_consume_token(int n) throws ParseException {
        Token token = ClusterReduction.token;
        ClusterReduction.token = token.next != null ? ClusterReduction.token.next : (ClusterReduction.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (ClusterReduction.token.kind == n) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return ClusterReduction.token;
        }
        ClusterReduction.token = token;
        jj_kind = n;
        throw ClusterReduction.generateParseException();
    }

    private static boolean jj_scan_token(int n) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (ClusterReduction.jj_scanpos.next == null) {
                jj_scanpos = ClusterReduction.jj_scanpos.next = token_source.getNextToken();
                jj_lastpos = ClusterReduction.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = ClusterReduction.jj_scanpos.next;
            }
        } else {
            jj_scanpos = ClusterReduction.jj_scanpos.next;
        }
        if (jj_rescan) {
            int n2 = 0;
            Token token = ClusterReduction.token;
            while (token != null && token != jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                ClusterReduction.jj_add_error_token(n, n2);
            }
        }
        if (ClusterReduction.jj_scanpos.kind != n) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = ClusterReduction.token.next != null ? ClusterReduction.token.next : (ClusterReduction.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int n) {
        Token token = ClusterReduction.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = token_source.getNextToken());
        }
        return token;
    }

    private static int jj_ntk() {
        jj_nt = ClusterReduction.token.next;
        if (jj_nt == null) {
            ClusterReduction.token.next = token_source.getNextToken();
            jj_ntk = ClusterReduction.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = ClusterReduction.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == jj_endpos + 1) {
            ClusterReduction.jj_lasttokens[ClusterReduction.jj_endpos++] = n;
        } else if (jj_endpos != 0) {
            int n3;
            jj_expentry = new int[jj_endpos];
            for (n3 = 0; n3 < jj_endpos; ++n3) {
                ClusterReduction.jj_expentry[n3] = jj_lasttokens[n3];
            }
            n3 = 0;
            Iterator<int[]> iterator = jj_expentries.iterator();
            while (iterator.hasNext()) {
                n3 = 1;
                int[] nArray = iterator.next();
                if (nArray.length != jj_expentry.length) continue;
                for (int i = 0; i < jj_expentry.length; ++i) {
                    if (nArray[i] == jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                jj_expentries.add(jj_expentry);
            }
            if (n2 != 0) {
                jj_endpos = n2;
                ClusterReduction.jj_lasttokens[ClusterReduction.jj_endpos - 1] = n;
            }
        }
    }

    public static ParseException generateParseException() {
        int n;
        int n2;
        jj_expentries.clear();
        boolean[] blArray = new boolean[25];
        if (jj_kind >= 0) {
            blArray[ClusterReduction.jj_kind] = true;
            jj_kind = -1;
        }
        for (n2 = 0; n2 < 0; ++n2) {
            if (jj_la1[n2] != jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 25; ++n2) {
            if (!blArray[n2]) continue;
            jj_expentry = new int[1];
            ClusterReduction.jj_expentry[0] = n2;
            jj_expentries.add(jj_expentry);
        }
        jj_endpos = 0;
        ClusterReduction.jj_rescan_token();
        ClusterReduction.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[jj_expentries.size()][];
        for (n = 0; n < jj_expentries.size(); ++n) {
            nArrayArray[n] = jj_expentries.get(n);
        }
        return new ParseException(token, nArrayArray, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 13; ++i) {
            try {
                JJCalls jJCalls = jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= jj_gen) continue;
                    jj_la = jJCalls.arg;
                    jj_lastpos = jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            ClusterReduction.jj_3_1();
                            break;
                        }
                        case 1: {
                            ClusterReduction.jj_3_2();
                            break;
                        }
                        case 2: {
                            ClusterReduction.jj_3_3();
                            break;
                        }
                        case 3: {
                            ClusterReduction.jj_3_4();
                            break;
                        }
                        case 4: {
                            ClusterReduction.jj_3_5();
                            break;
                        }
                        case 5: {
                            ClusterReduction.jj_3_6();
                            break;
                        }
                        case 6: {
                            ClusterReduction.jj_3_7();
                            break;
                        }
                        case 7: {
                            ClusterReduction.jj_3_8();
                            break;
                        }
                        case 8: {
                            ClusterReduction.jj_3_9();
                            break;
                        }
                        case 9: {
                            ClusterReduction.jj_3_10();
                            break;
                        }
                        case 10: {
                            ClusterReduction.jj_3_11();
                            break;
                        }
                        case 11: {
                            ClusterReduction.jj_3_12();
                            break;
                        }
                        case 12: {
                            ClusterReduction.jj_3_13();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        jj_rescan = false;
    }

    private static void jj_save(int n, int n2) {
        JJCalls jJCalls = jj_2_rtns[n];
        while (jJCalls.gen > jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = jj_gen + n2 - jj_la;
        jJCalls.first = token;
        jJCalls.arg = n2;
    }

    static {
        seenLeaves = 0;
        VERBOSE = false;
        xUpDownSuffix = null;
        leaves = 0;
        trees = 0;
        VERSION = "// ClusterReduction.jj Version 1.0 by Steven Kelk, January 9th 2026\n";
        jj_initialized_once = false;
        jj_la1 = new int[0];
        ClusterReduction.jj_la1_init_0();
        jj_2_rtns = new JJCalls[13];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

